 
  import java.util.*;
  
  // A single score
  class Score {
    // has the name of the player
    String name;
    // and his/her score
    int score;
    String time;
    // Constructor
    Score(String name, int score, String time) {
      this.name = name;
      this.score = score;
      this.time = time;
    }
  }
  
  // ScoreList class manages a list of scores
  class ScoreList {
    ArrayList<Score> scores = new ArrayList<Score>();
    Table scoreTable;
  
    // Constructor
    ScoreList() {
      scoreTable = new Table();
      scoreTable.addColumn("name");
      scoreTable.addColumn("score");
      scoreTable.addColumn("Time");
    }
  
    // Create a new Score and add it to the scores ArrayList
    void addScore(String name, int score, String time) {
      // Add a new score object to the scores ArrayList
      scores.add(new Score(name, score, time));
      // Sort the scores ArrayList after each score is added
      sortScores();
    }
  
    // return amount of scores in scores ArrayList 
    int getScoreCount() {
      return scores.size();
    }
  
    // return the score at iScore
    Score getScore(int iScore) {
      return scores.get(iScore);
    }
  
    // Sort the scores ArrayList
    void sortScores() {  
      Collections.sort(scores, new HSComperator());
    }
  
    // Save scores to file named "scoreFileName"
    void save(String scoreFileName) {
      // Copy scores from ArrayList to table
      for (Score score : scores) {
        TableRow row = scoreTable.addRow();
        row.setString("name", score.name);
        row.setInt("score", score.score);
        row.setString("time", score.time);
      }
  
      // save the table to file
      saveTable(scoreTable, scoreFileName);
    }
  
  
    // Load scores from file called "scoreFileName"
    void load(String scoreFileName) {
  
      // Load the scores into the Table object
      scoreTable = loadTable(scoreFileName, "header");
  
      // copy scores from table to the scores array
      for (int iScore=0; iScore<scoreTable.getRowCount (); iScore++) {
        TableRow row = scoreTable.getRow(iScore);
        scores.add(new Score(row.getString("name"), row.getInt("score"), row.getString("time")));
      }
    }
  }
  
  
  // Comperator class is needed in order for processing to know how
  // to sort a list of scores
  class HSComperator implements Comparator<Score> {
    @Override
      public int compare(Score o1, Score o2) {
      return o2.score - o1.score;
    }
  }
  
  class TypeYourName {
    char startInitial1, initial1, initial2, initial3;
    String stringInitial1, stringInitial2, stringInitial3;
    int textbox;
    float underscoreX, underscoreY;
    void init() {
      textbox = 0;
      initial1 = 'A';
  
      initial2 = 'A';
      initial3 = 'A';
      underscoreX= width/2+169;
      underscoreY = 155;
    }
    void draw() {
      if (nutsLeft == 0) {
        if (textbox >0) {
          text("Press [W] to choose and [D] to confirm initials, then hold [S] to see Scores!", width/2-500, 100);
          if (textbox == 1) {
            if (keysPressed['W'] && initial1 != 'Z') {
              initial1++;
              keysPressed['W'] = false;
            }
            if (keysPressed['W'] && initial1 == 'Z') {
              initial1 = 'A';
              keysPressed['W'] = false;
            }
            if (keysPressed['D']) {
              textbox++;
              underscoreX +=19;
              keysPressed['D'] = false;
            }
          }
  
          if (textbox == 2) {
            if (keysPressed['W'] && initial2 != 'Z' ) {
              initial2++;
              keysPressed['W'] = false;
            }
            if (keysPressed['W'] && initial2 == 'Z') {
              initial2 = 'A';
              keysPressed['W'] = false;
            }
            if (keysPressed['D']) {
              textbox++;
              underscoreX +=19;
              keysPressed['D'] = false;
            }
          }
          if (textbox == 3) {
            if (keysPressed['W'] && initial3 != 'Z' ) {
              initial3++;
              keysPressed['W'] = false;
            }
            if (keysPressed['W'] && initial3 == 'Z') {
              initial3 = 'A';
              keysPressed['W'] = false;
            }
  
  
            switch(initial1) {
            case 'A':  
              stringInitial1 = "A";
              break;
            case 'B':  
              stringInitial1 = "B";
              break;
            case 'C':  
              stringInitial1 = "C";
              break;
            case 'D':  
              stringInitial1 = "D";
              break;
            case 'E':  
              stringInitial1 = "E";
              break;
            case 'F':  
              stringInitial1 = "F";
              break;
            case 'G':  
              stringInitial1 = "G";
              break;
            case 'H':  
              stringInitial1 = "H";
              break;
            case 'I':  
              stringInitial1 = "I";
              break;
            case 'J':  
              stringInitial1 = "J";
              break;
            case 'K':  
              stringInitial1 = "K";
              break;
            case 'L':  
              stringInitial1 = "L";
              break;
            case 'M':  
              stringInitial1 = "M";
              break;
            case 'N':  
              stringInitial1 = "N";
              break;
            case 'O':  
              stringInitial1 = "O";
              break;
            case 'P':  
              stringInitial1 = "P";
              break;
            case 'Q':  
              stringInitial1 = "Q";
              break;
            case 'R':  
              stringInitial1 = "R";
              break;
            case 'S':  
              stringInitial1 = "S";
              break;
            case 'T':  
              stringInitial1 = "T";
              break;
            case 'U':  
              stringInitial1 = "U";
              break;
            case 'V':  
              stringInitial1 = "V";
              break;
            case 'W':  
              stringInitial1 = "W";
              break;
            case 'X':  
              stringInitial1 = "X";
              break;
            case 'Y':  
              stringInitial1 = "Y";
              break;
            case 'Z':  
              stringInitial1 = "Z";
              break;
            }
            switch(initial2) {
            case 'A':  
              stringInitial2 = "A";
              break;
            case 'B':  
              stringInitial2 = "B";
              break;
            case 'C':  
              stringInitial2 = "C";
              break;
            case 'D':  
              stringInitial2 = "D";
              break;
            case 'E':  
              stringInitial2 = "E";
              break;
            case 'F':  
              stringInitial2 = "F";
              break;
            case 'G':  
              stringInitial2 = "G";
              break;
            case 'H':  
              stringInitial2 = "H";
              break;
            case 'I':  
              stringInitial2 = "I";
              break;
            case 'J':  
              stringInitial2 = "J";
              break;
            case 'K':  
              stringInitial2 = "K";
              break;
            case 'L':  
              stringInitial2 = "L";
              break;
            case 'M':  
              stringInitial2 = "M";
              break;
            case 'N':  
              stringInitial2 = "N";
              break;
            case 'O':  
              stringInitial2 = "O";
              break;
            case 'P':  
              stringInitial2 = "P";
              break;
            case 'Q':  
              stringInitial2 = "Q";
              break;
            case 'R':  
              stringInitial2 = "R";
              break;
            case 'S':  
              stringInitial2 = "S";
              break;
            case 'T':  
              stringInitial2 = "T";
              break;
            case 'U':  
              stringInitial2 = "U";
              break;
            case 'V':  
              stringInitial2 = "V";
              break;
            case 'W':  
              stringInitial2 = "W";
              break;
            case 'X':  
              stringInitial2 = "X";
              break;
            case 'Y':  
              stringInitial2 = "Y";
              break;
            case 'Z':  
              stringInitial2 = "Z";
              break;
            }
            switch(initial3) {
            case 'A':  
              stringInitial3 = "A";
              break;
            case 'B':  
              stringInitial3 = "B";
              break;
            case 'C':  
              stringInitial3 = "C";
              break;
            case 'D':  
              stringInitial3 = "D";
              break;
            case 'E':  
              stringInitial3 = "E";
              break;
            case 'F':  
              stringInitial3 = "F";
              break;
            case 'G':  
              stringInitial3 = "G";
              break;
            case 'H':  
              stringInitial3 = "H";
              break;
            case 'I':  
              stringInitial3 = "I";
              break;
            case 'J':  
              stringInitial3 = "J";
              break;
            case 'K':  
              stringInitial3 = "K";
              break;
            case 'L':  
              stringInitial3 = "L";
              break;
            case 'M':  
              stringInitial3 = "M";
              break;
            case 'N':  
              stringInitial3 = "N";
              break;
            case 'O':  
              stringInitial3 = "O";
              break;
            case 'P':  
              stringInitial3 = "P";
              break;
            case 'Q':  
              stringInitial3 = "Q";
              break;
            case 'R':  
              stringInitial3 = "R";
              break;
            case 'S':  
              stringInitial3 = "S";
              break;
            case 'T':  
              stringInitial3 = "T";
              break;
            case 'U':  
              stringInitial3 = "U";
              break;
            case 'V':  
              stringInitial3 = "V";
              break;
            case 'W':  
              stringInitial3 = "W";
              break;
            case 'X':  
              stringInitial3 = "X";
              break;
            case 'Y':  
              stringInitial3 = "Y";
              break;
            case 'Z':  
              stringInitial3 = "Z";
              break;
            }
            if (keysPressed['S']) {
              highscores.addScore(stringInitial1 + stringInitial2 + stringInitial3, time.points, time.theTime);
              keysPressed['S'] = false;
              textbox++;
              underscoreX = width/2+169;
            }
          }
  
  
          text("Enter Initials: " + initial1 + "" + initial2 + "" + initial3, width/2, 150);
          text("_", underscoreX, underscoreY);
        }
      }
    }
  }
